% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R, R/print_lazy.R
\name{print.selenider_element}
\alias{print.selenider_element}
\alias{print.selenider_elements}
\alias{print_lazy}
\alias{print_lazy.selenider_element}
\alias{print_lazy.selenider_elements}
\title{Print a live HTML element}
\usage{
\method{print}{selenider_element}(x, width = getOption("width"), ..., timeout = NULL)

\method{print}{selenider_elements}(x, width = getOption("width"), ..., n = 20, timeout = NULL)

print_lazy(x, ...)

\method{print_lazy}{selenider_element}(x, ...)

\method{print_lazy}{selenider_elements}(x, ...)
}
\arguments{
\item{x}{A \code{selenider_element} or \code{selenider_elements} object.}

\item{width}{The maximum width of the output.}

\item{...}{Not used.}

\item{timeout}{How long to wait for \code{x} to exist in order to print its HTML.}

\item{n}{The maximum number of elements to print.}
}
\value{
\code{x}, invisibly.
}
\description{
Display an element or collection of elements by fetching the elements and
displaying their HTML contents.

\code{print_lazy()} allows an element to be printed without fetching it, by
displaying a summary of the steps that will be taken to reach the element.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<div>
<p>Text 1</p>
<p>Text 2</p>
<p>Text 3</p>
<p>Text 4</p>
</div>
"

session <- minimal_selenider_session(html)

print(s("div"))

print(ss("p"))

print(ss("p"), n = 3)

s("div") |>
  find_elements("p") |>
  elem_filter(has_text("Text 3")) |>
  print_lazy()

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
