% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectSNPs_utility.R
\docType{methods}
\name{scoreU}
\alias{scoreU}
\alias{scoreU,Chrom-method}
\alias{scoreU,Map-method}
\title{Compute the Uniformness(U) score}
\usage{
scoreU(object, ...)

\S4method{scoreU}{Chrom}(object)

\S4method{scoreU}{Map}(object, chrom)
}
\arguments{
\item{object}{An input object, which can be a vector of map position, a Chrom object, or a Map object.}

\item{...}{Extra input parameters, as needed.}

\item{chrom}{Names of the chromosomes for which the U score is to be computed; Optional.}
}
\value{
The computed U score of the input object.
}
\description{
This function computes the (U) scores, which measures the uniformness of all the markers
on one or more chromsoomes.
}
\examples{
data(bov80K)
scoreU(bov80K)

}
\references{
{
1. Wu XL, Li H, Ferretti R, Simpson B, Walker J, Parham J, Mastro L, Qiu J, Schultz T, Tait RG Jr, 
Bauck S, (2010). A unified local objective function for optimally selecting SNPs on arrays for 
agricultural genomics applications. Anim Genet. 2020 Jan 31. doi: 10.1111/age.12916. 

2. Wu XL, Xu J, Feng G, Wiggans GR, Taylor JF, He J, Qian C, Qiu J, Simpson B, Walker J, Bauck S. 
(2016). Optimal Design of Low-Density SNP Arrays for Genomic Prediction: Algorithm and Applications.
PLoS One. 11(9):0161719. doi: 10.1371/journal.pone.0161719. 
}
}
\author{
Nick X-L Wu
}
