% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectSNPs_utility.R
\docType{methods}
\name{newMap}
\alias{newMap}
\alias{newMap,data.frame,data.frame-method}
\alias{newMap,data.frame}
\alias{newMap,character,character-method}
\alias{newMap,character}
\title{Create a new \code{Map} object.}
\usage{
newMap(map, freq, ...)

\S4method{newMap}{data.frame,data.frame}(map, freq)

\S4method{newMap}{character,character}(map, freq, type = "C", status = 0)
}
\arguments{
\item{map}{An input map or manifest file. A typical manifest file has the following columns: Index,
Name,    Chromosome,    Position,    GenTrain Score, SNP, ILMN Strand, Customer Strand, and NormID.}

\item{freq}{An input object containing genotypes, which can be either the name of the input DNA report
file name object, or a data frame containing genotypes. A DNA report file has 9 header lines (which
will be skipped when reading). The column names are on the tenth lines and the genotypes start from the
eleventh lines, separated by tabs.}

\item{...}{Extra parameters as needed.}

\item{type}{The types of a SNP, which by default is "C".}

\item{status}{The status of a SNP, which by default is all 0 (i.e., non-obligatory SNPs).}
}
\value{
An \code{Map} object.
}
\description{
This S4 function is used to create a new \code{Map} object. The input information is taken
from an input DNA report in matrix format, plus a map or manifest file.
}
\author{
Nick X-L Wu
}
