% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrt_glpknown.R
\name{like_glpknown_3}
\alias{like_glpknown_3}
\title{Likelihood under three parameter model when using offspring genotypes
likelihoods but parent genotypes are known.}
\usage{
like_glpknown_3(gl, tau, beta, gamma1, gamma2, g1, g2, log_p = TRUE)
}
\arguments{
\item{gl}{The matrix of genotype likelihoods of the offspring. Rows index
The individuals, columns index the genotypes.}

\item{tau}{The probability of quadrivalent formation.}

\item{beta}{The probability of double reduction given quadrivalent formation.}

\item{gamma1}{The probability of AA_aa pairing for parent 1.}

\item{gamma2}{The probability of AA_aa pairing for parent 2.}

\item{g1}{Parent 1's genotype.}

\item{g2}{Parent 2's genotype.}

\item{log_p}{A logical. Should we return the log likelihood or not?}
}
\value{
The (log) likelihood of the three parameter model when using
genotype likelihoods.
}
\description{
This is under the three parameter model.
}
\examples{
g1 <- 1
g2 <- 0
gl <- simf1gl(
  n = 25,
  g1 = g1,
  g2 = g2,
  rd = 10,
  alpha = 0,
  xi1 = 1/3,
  xi2 = 1/3)
like_glpknown_3(
  gl = gl,
  tau = 1/2,
  beta = 1/12,
  gamma1 = 1/3,
  gamma2 = 1/3,
  g1 = g1,
  g2 = g2,
  log_p = TRUE)

}
\author{
David Gerard
}
