% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_map_plot.R
\name{map_segm}
\alias{map_segm}
\title{\code{plot_segm} plot segmented traject on a map.}
\usage{
map_segm(data, output, interactive = F, html = F, scale = 1,
  UTMstring = "+proj=longlat +datum=WGS84 +no_defs", width = 400,
  height = 400, order = NULL, pointsize = 1, linesize = 0.5,
  coord.names = c("x", "y"))
}
\arguments{
\item{data}{the data.frame with the different variable}

\item{output}{outputs of the segmentation  or segclust algorithm for one
number of segment}

\item{interactive}{should graph be interactive with leaflet ?}

\item{html}{should the graph be incorporated in a markdown file through
htmltools::tagList()}

\item{scale}{for dividing coordinates to have compatibility with leaflet}

\item{UTMstring}{projection of the coordinates}

\item{width}{width}

\item{height}{height}

\item{order}{should cluster be ordered}

\item{pointsize}{size of points}

\item{linesize}{size of lines}

\item{coord.names}{names of coordinates}
}
\value{
a graph
}
\description{
\code{plot_segm} plot segmented traject on a map.
}
\examples{
\dontrun{
#res.seg is a result of the segmentation-only algorithm : 
nseg = 10
outputs = res.seg$outputs[[paste(nseg, "segments")]]
map <- map_segm(data=res.seg$data,output=outputs)
#res.segclust is a result of the segmentation-clusturing algorithm : 
nseg = 10; ncluster = 3
outputs = res.segclust$outputs[[paste(ncluster,"class -",nseg, "segments")]]
map <- map_segm(data=res.seg$data,output=outputs)
}

}
