% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_blackboard.R
\name{theme_blackboard}
\alias{theme_blackboard}
\title{Blackboard dark theme}
\usage{
theme_blackboard(base_size = 11, base_family = "",
  plot.title.size = 15, plot.title.face = "plain",
  plot.title.space = 20, legend.position = "right",
  axis.title.space = 20, legend.title.size = 13,
  legend.text.size = 12, axis.title.size = 13,
  axis.title.face = "plain", axis.text.size = 12,
  axis.text.angle = NULL, tags.size = 15, tags.face = "bold")
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}

\item{plot.title.size}{Title size in pts. Can be "none".}

\item{plot.title.face}{Title font face ("plain", "italic", "bold", "bold.italic").}

\item{plot.title.space}{Title spacing.}

\item{legend.position}{the position of legends ("none", "left", "right",
"bottom", "top", or two-element numeric vector)}

\item{axis.title.space}{Axis title spacing.}

\item{legend.title.size}{Legend elements text size in pts.}

\item{legend.text.size}{Legend elements text size in pts. Can be "none".}

\item{axis.title.size}{Axis title text size in pts.}

\item{axis.title.face}{Axis font face ("plain", "italic", "bold", "bold.italic").}

\item{axis.text.size}{Axis text size in pts.}

\item{axis.text.angle}{Rotate  the x axis labels.}

\item{tags.size}{Tags text size in pts.}

\item{tags.face}{Tags font face ("plain", "italic", "bold", "bold.italic").}
}
\description{
A modern, sleek and dark theme for ggplot.
}
\examples{
library(ggplot2)
library(see)

ggplot(iris, aes(x = Sepal.Width, y = Sepal.Length)) +
  geom_point(color="white") +
  theme_blackboard()
}
