% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sectxt.r
\name{sectxt}
\alias{sectxt}
\title{Parse a \code{security.txt} Web Security Policies file & create a \code{sectxt} object}
\usage{
sectxt(x)
}
\arguments{
\item{x}{either an atomic character vector containing a complete \code{security.txt} file
\emph{or} a length >1 character vector that will be concatenated into a single string \emph{or}
a \code{connection} object that will be passed to \code{\link[=readLines]{readLines()}}, the result of which
will be concatenated into a single string and parsed and the connection will be closed.}
}
\description{
This function takes in a single element character vector and parses it into
a \code{sectxt} object.
}
\examples{
sectxt(readLines(system.file("extdata", "security.txt", package="securitytxt")))
\dontrun{
sectxt(url(sectxt_url("https://securitytxt.org")))
}
}
\references{
\itemize{
\item \href{https://tools.ietf.org/html/draft-foudil-securitytxt-00}{IETF Draft}
\item \href{https://securitytxt.org/}{Information hub}
\item \href{https://github.com/securitytxt}{GitHub Organization}
}
}
