% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{base64enc}
\alias{base64enc}
\title{Base64 Encode}
\usage{
base64enc(x, convert = TRUE)
}
\arguments{
\item{x}{an object.}

\item{convert}{[default TRUE] logical TRUE to encode to a character string or
FALSE to a raw vector.}
}
\value{
A character string or raw vector depending on the value of
    \sQuote{convert}.
}
\description{
Encodes a character string, raw vector or other object to base64 encoding.
}
\details{
A character string or raw vector (with no attributes) is encoded
    \emph{as is}, whilst all other objects are first serialized (using R
    serialisation version 3, big-endian representation).
}
\examples{
base64enc("secret base")
base64enc(as.raw(c(1L, 2L, 4L)), convert = FALSE)
base64enc(data.frame())

}
\references{
This implementation is based that by 'The Mbed TLS Contributors'
    under the 'Mbed TLS' Trusted Firmware Project at
    \url{https://www.trustedfirmware.org/projects/mbed-tls}.
}
\seealso{
\code{\link{base64dec}}
}
