% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/case.R
\name{ignore.case}
\alias{case_insensitive}
\alias{case_sensitive}
\alias{ignore.case}
\alias{ignore.case.SearchableOrPattern}
\alias{ignore.case.character}
\alias{ignore.case.default}
\alias{use.case}
\alias{use.case.SearchableOrPattern}
\alias{use.case.character}
\alias{use.case.default}
\title{Turn on/off case sensitivity for Searchable and Pattern objects}
\usage{
ignore.case(object)

\method{ignore.case}{SearchableOrPattern}(object, ...)

\method{ignore.case}{character}(object)

\method{ignore.case}{default}(object)

case_insensitive(object)

use.case(object)

\method{use.case}{SearchableOrPattern}(object)

\method{use.case}{character}(object)

\method{use.case}{default}(object)

case_sensitive(object)
}
\arguments{
\item{object}{search pattern or target}

\item{...}{additional arguments

\code{ignore.case}/\code{case_insensitive} and
\code{use.case}/\code{case_sensitive} control the case sensitivity of the
matching

The default is to perform case-sensitive matching.}
}
\description{
Functions for affecting the case sensitivity of matching/
}
\examples{
use.case("pattern")     # case-sensitive (Default)
  ignore.case("pattern")  # case-insensitive
}
\seealso{
\code{stri_detect_*} from the \code{stringi} package
}

