% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtc_utils.R
\name{assert_capture_matrix}
\alias{assert_capture_matrix}
\title{Assert capture matrix}
\usage{
assert_capture_matrix(m)
}
\arguments{
\item{m}{A character matrix.}
}
\value{
This function throws an error if \code{m} is not either:
\itemize{
\item A character matrix;
\item A matrix whose columns are (at least): \code{year}, \code{mon}, \code{mday}, \code{hour},
\code{min} and \code{sec}.
}

Otherwise, it returns \code{m} invisibly.
}
\description{
\code{\link[=assert_capture_matrix]{assert_capture_matrix()}} is an internal helper function aiding with the
checking of an internal R object that contains the parsing results as
returned by \code{\link[=parse_dttm]{parse_dttm()}}: capture matrix.

This function checks that the capture matrix is a matrix and that it contains
six columns: \code{year}, \code{mon}, \code{mday}, \code{hour}, \code{min} and \code{sec}.
}
\keyword{internal}
