% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ct.R
\name{ct_map}
\alias{ct_map}
\title{Recode according to controlled terminology}
\usage{
ct_map(
  x,
  ct_spec = NULL,
  ct_clst = NULL,
  from = ct_spec_vars("from"),
  to = ct_spec_vars("to")
)
}
\arguments{
\item{x}{A character vector of terms to be recoded following a controlled
terminology.}

\item{ct_spec}{A \link[tibble:tibble-package]{tibble} providing a controlled
terminology specification.}

\item{ct_clst}{A character vector indicating a set of possible controlled
terminology codelists codes to be used for recoding. By default (\code{NULL})
all codelists available in \code{ct_spec} are used.}

\item{from}{A character vector of column names indicating the variables
containing values to be matched against for terminology recoding.}

\item{to}{A single string indicating the column whose values are to be
recoded into.}
}
\value{
A character vector of terminology recoded values from \code{x}. If no
match is found in the controlled terminology spec provided in \code{ct_spec}, then
\code{x} values are returned in uppercase. If \code{ct_spec} is not provided \code{x} is
returned unchanged.
}
\description{
\code{\link[=ct_map]{ct_map()}} recodes a vector following a controlled terminology.
}
\examples{
# A few example terms.
terms <-
  c(
    "/day",
    "Yes",
    "Unknown",
    "Prior",
    "Every 2 hours",
    "Percentage",
    "International Unit"
  )

# Load a controlled terminology example
(ct_spec <- read_ct_spec_example("ct-01-cm"))

# Use all possible matching terms in the controlled terminology.
ct_map(x = terms, ct_spec = ct_spec)

# Note that if the controlled terminology mapping is restricted to a codelist
# code, e.g. C71113, then only `"/day"` and `"Every 2 hours"` get mapped to
# `"QD"` and `"Q2H"`, respectively; remaining terms won't match given the
# codelist code restriction, and will be mapped to an uppercase version of
# the original terms.
ct_map(x = terms, ct_spec = ct_spec, ct_clst = "C71113")

}
