% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtc_problems.R
\name{add_problems}
\alias{add_problems}
\title{Add ISO 8601 parsing problems}
\usage{
add_problems(x, is_problem, dtc)
}
\arguments{
\item{x}{A character vector of date-times in ISO 8601 format; typically, the
output of \code{\link[=format_iso8601]{format_iso8601()}}.}

\item{is_problem}{A \code{logical} indicating which date/time inputs are
associated with parsing failures.}

\item{dtc}{A list of \code{character} vectors of dates, times or date-times'
components. Typically, this parameter takes the value passed in \code{...} to
a \code{\link[=create_iso8601]{create_iso8601()}} call.}
}
\value{
Either \code{x} without any modification, if no parsing problems exist,
or an annotated \code{x}, meaning having a \code{problems} attribute that holds
parsing issues (see the Details section).
}
\description{
\code{\link[=add_problems]{add_problems()}} annotates the returned value of \code{\link[=create_iso8601]{create_iso8601()}} with
possible parsing problems. This annotation consists of a
\link[tibble:tibble-package]{tibble} of problems, one row for each parsing
failure (see Details section).
}
\details{
This function annotates its input \code{x}, a vector date-times in ISO 8601
format, by creating an attribute named \code{problems}. This attribute's value
is a \link[tibble:tibble-package]{tibble} of parsing problems. The problematic
date/times are indicated by the \code{logical} vector passed as argument to
\code{is_problem}.

The attribute \code{problems} in the returned value will contain a first column
named \code{..i} that indicates the date/time index of the problematic date/time
in \code{x}, and as many extra columns as there were inputs (passed in \code{dtc}). If
\code{dtc} is named, then those names are used to name the extra columns,
otherwise they get named sequentially like so \code{..var1}, \code{..var2}, etc..
}
\keyword{internal}
