% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdmApp_fold_Explorer.R
\name{sdmApp_fold_Explorer}
\alias{sdmApp_fold_Explorer}
\title{Explore the generated folds and visualize the placement of folds and distribution of species data over folds.}
\usage{
sdmApp_fold_Explorer(blocks, rasterLayer, speciesData, num)
}
\arguments{
\item{blocks}{A \code{SpatialBlock} object.}

\item{rasterLayer}{A raster object as background map for visualization.}

\item{speciesData}{A simple features (sf) or \code{SpatialPoints} object containing species data (response variable).}

\item{num}{A number of fold to assign as data test set.}
}
\value{
A map showing folds and the species data, that can be used to explore folds.
}
\description{
Explore the generated folds and visualize the placement of folds and distribution of species data over folds.
}
\examples{
\dontrun{
# load blockCV package data
library(blockCV)
awt <- raster::brick(system.file("extdata", "awt.grd", package = "blockCV"))
#import presence-absence species data
PA <- read.csv(system.file("extdata", "PA.csv", package = "blockCV"))
#make a sf object from data.frame
pa_data <- sf::st_as_sf(PA, coords = c("x", "y"), crs = raster::crs(awt))
#spatial blocking by specified range and random assignment
sb <- spatialBlock(speciesData = pa_data,species = "Species",
rasterLayer = awt,theRange = 70000,k = 5,
selection = "random",iteration = 100)
sdmApp_fold_Explorer(sb,awt,pa_data,1)
}
}
