% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OU.R
\name{dTpdMou}
\alias{dTpdMou}
\alias{meantMou}
\alias{covtMou}
\title{Transition probability density of the multivariate OU diffusion}
\usage{
dTpdMou(x, x0, t, A, mu, Sigma, eigA = NULL, log = FALSE)

meantMou(t, x0, A, mu, eigA = NULL)

covtMou(t, A, Sigma, eigA = NULL)
}
\arguments{
\item{x}{matrix of with \code{p} columns containing the evaluation points.}

\item{x0}{initial point.}

\item{t}{time between observations.}

\item{A}{the drift matrix, of size \code{c(p, p)}.}

\item{mu}{unconditional mean of the diffusion.}

\item{Sigma}{square of the diffusion matrix, a matrix of size \code{c(p, p)}.}

\item{eigA}{optional argument containing \code{eigen(A)} for reuse.}

\item{log}{flag to indicate whether to compute the logarithm of the density.}
}
\value{
A matrix of the same size as \code{x} containing the evaluation of the density.
}
\description{
Transition probability density of the \emph{multivariate} Ornstein--Uhlenbeck (OU) diffusion
\deqn{dX_t=A(\mu - X_t)dt+\Sigma^\frac{1}{2}dW_t, X_0=x_0.}{dX_t=A(mu - X_t)dt+Sigma^(1/2) dW_t, X0=x0.}
}
\details{
The transition probability density is a multivariate normal with mean \code{\link{meantMou}} and covariance \code{\link{covtMou}}. See \code{\link{dTpdOu}} for the univariate case (more efficient).

\code{solve(A) \%*\% Sigma} has to be a covariance matrix (symmetric and positive definite) in order to have a proper transition density. For the bivariate case, this can be ensured with the \code{\link{alphaToA}} function. In the multivariate case, it is ensured if \code{Sigma} is isotropic and \code{A} is a covariance matrix.
}
\examples{
x <- seq(-4, 4, by = 0.1)
xx <- as.matrix(expand.grid(x, x))
isRStudio <- identical(.Platform$GUI, "RStudio")
if (isRStudio) {
  manipulate::manipulate(
    image(x, x, matrix(dTpdMou(x = xx, x0 = c(1, 2), t = t,
                               A = alphaToA(alpha = c(1, 2, 0.5),
                                            sigma = 1:2),
                               mu = c(0, 0), Sigma = diag((1:2)^2)),
                       nrow = length(x), ncol = length(x)),
          zlim = c(0, 0.25)), t = manipulate::slider(0.1, 5, step = 0.1))
}
}
