% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/muargus_compatibility_functions.R
\name{argus_microaggregation}
\alias{argus_microaggregation}
\title{argus_microaggregation}
\usage{
argus_microaggregation(df, k, useOptimal = FALSE)
}
\arguments{
\item{df}{a \code{data.frame} with only numerical columns}

\item{k}{required group size}

\item{useOptimal}{(logical) should optimal microaggregation be applied (ony possible in
in case of one variable)}
}
\value{
a \code{list} with two elements
\itemize{
\item{original: } the originally provided input data
\item{microaggregated: } the microaggregated data.frame
}
}
\description{
calls microaggregation code from mu-argus. In case only one variable should be
microaggregated and \code{useOptimal} is \code{TRUE}, Hansen-Mukherjee polynomial exact method
is applied. In any other case, the Mateo-Domingo method is used.
}
\examples{
mat <- matrix(sample(1:100, 50, replace=TRUE), nrow=10, ncol=5)
df <- as.data.frame(mat)
res <- argus_microaggregation(df, k=5, useOptimal=FALSE)
}
\seealso{
mu-Argus manual at \url{https://github.com/sdcTools/manuals/raw/master/mu-argus/MUmanual5.1.pdf}
}
