% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localSuppression.R
\name{plot.localSuppression}
\alias{plot.localSuppression}
\title{plot method for localSuppression objects}
\usage{
\method{plot}{localSuppression}(x, ...)
}
\arguments{
\item{x}{object of class \sQuote{localSuppression}}

\item{\dots}{Additional arguments, currently available are:
\itemize{
\item showDetails logical, if set, a plot of suppressions by
strata is shown (if possible)
}}
}
\description{
Barplot for objects from class localSuppression.
}
\details{
Just look at the resulting plot.
}
\examples{
## example from Capobianchi, Polettini and Lucarelli:
data(francdat)
l1 <- localSuppression(francdat, keyVars=c(2,4,5,6))
l1
plot(l1)

## with details of suppression by strata
data(testdata2)
testdata2$ageG <- cut(testdata2$age, 5, labels=paste0("AG",1:5))
keyVars <- c("urbrur","roof","walls","water","electcon","relat","sex")
strataVars <- c("ageG")
inp <- testdata2[,c(keyVars, strataVars)]
ls <- localSuppression(inp, keyVars=1:7, strataVars=8)
print(ls)
plot(ls)
plot(ls, showDetails=TRUE)

}
\seealso{
\code{\link{localSuppression}}
}
\author{
Bernhard Meindl, Matthias Templ
}
\keyword{aplot}
