% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{use_threads}
\alias{use_threads}
\title{Set up threaded ensemble simulations}
\usage{
use_threads(n = parallel::detectCores() - 1, stop = FALSE)
}
\arguments{
\item{n}{Number of Julia threads to use. Defaults to parallel::detectCores() - 1. If set to a value higher than the number of available cores minus 1, it will be set to the number of available cores minus 1.}

\item{stop}{Stop using threaded ensemble simulations. Defaults to FALSE.}
}
\value{
No return value, called for side effects
}
\description{
Specify the number of threads for ensemble simulations in Julia. This will not overwrite your current global setting for JULIA_NUM_THREADS. Note that this does not affect regular simulations with \code{\link[=simulate]{simulate()}}.
}
\examples{
\dontshow{if (julia_status()$status == "ready") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Use Julia with 4 threads
use_julia()
use_threads(n = 4)

# Stop using threads
use_threads(stop = TRUE)

# Stop using Julia
use_julia(stop = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=ensemble]{ensemble()}}, \code{\link[=use_julia]{use_julia()}}
}
\concept{julia}
