% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoringRules_wrappers.R
\name{logs}
\alias{logs}
\title{LogS}
\usage{
logs(true_values, predictions)
}
\arguments{
\item{true_values}{A vector with the true observed values of size n}

\item{predictions}{nxN matrix of predictive samples, n (number of rows) being
the number of data points and N (number of columns) the
number of Monte Carlo samples}
}
\value{
vector with the scoring values
}
\description{
Wrapper around the \code{\link[scoringRules:scores_sample_univ]{logs_sample}}
function from the
\code{scoringRules} package. Used to score continuous predictions.
While the Log Score is in theory also applicable
to integer forecasts, the problem lies in the implementation: The Log Score
needs a kernel density estimation, which is not well defined with
integer-valued Monte Carlo Samples. The Log Score can be used for specific
integer valued probability distributions. See the scoringRules package for
more details.
}
\examples{
true_values <- rpois(30, lambda = 1:30)
predictions <- replicate(200, rpois(n = 30, lambda = 1:30))
logs(true_values, predictions)
}
\references{
Alexander Jordan, Fabian Krüger, Sebastian Lerch, Evaluating Probabilistic
Forecasts withscoringRules, https://arxiv.org/pdf/1709.04743.pdf
}
