% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bingham.R
\name{Bingham}
\alias{Bingham}
\title{Score Matching Estimators for the Bingham Distribution}
\usage{
Bingham(Y, A = NULL, w = rep(1, nrow(Y)), method = "Mardia")
}
\arguments{
\item{Y}{A matrix of multivariate observations in Cartesian coordinates. Each row is a multivariate measurement (i.e. each row corresponds to an individual).}

\item{A}{For full score matching only: if supplied, then NA elements of \code{A} are estimated and the other elements are fixed. For identifiability the final element of \code{diag(A)} must be \code{NA}.}

\item{w}{An optional vector of weights for each measurement in \code{Y}}

\item{method}{Either "Mardia" or "hybrid" for the hybrid score matching estimator from \insertCite{mardia2016sc;textual}{scorematchingad}
or "smfull" for the full score matching estimator.}
}
\value{
A list of \code{est}, \code{SE} and \code{info}.
\itemize{
\item \code{est} contains the estimated matrix \code{A} and a vector form, \code{paramvec}, of \code{A} (ordered according to \code{c(diag(A)[1:(p-1)], A[upper.tri(A)])} ). For the Mardia method, the estimated eigenvalues of \code{A} (named \code{evals}) and eigenvectors of \code{A} (named \code{G}) are also returned.
\item \code{SE} contains estimates of the standard errors if computed. See \code{\link[=cppad_closed]{cppad_closed()}}.
\item \code{info} contains a variety of information about the model fitting procedure and results.
}
}
\description{
Score matching estimators for the Bingham distribution's parameter matrix. Two methods are available: a full score matching method that estimates the parameter matrix directly and a hybrid method by \insertCite{mardia2016sc;textual}{scorematchingad} that uses score matching to estimate just the eigenvalues of the parameter matrix.
}
\details{
The Bingham distribution has a density proportional to
\deqn{\exp(z^T A z),}
where \eqn{A} is a symmetric matrix and the trace (sum of the diagonals) of \eqn{A} is zero for identifiability \insertCite{@p181, @mardia2000di}{scorematchingad}.

The full score matching method estimates all elements of \eqn{A} directly except the final element of the diagonal, which is calculated from the sum of the other diagonal elements to ensure that the trace of \eqn{A} is zero.

The method by \insertCite{mardia2016sc;textual}{scorematchingad} first calculates the maximum-likelihood estimate of the eigenvectors \eqn{G} of \eqn{A}.
The observations \code{Y} are then standardised to \code{Y}\eqn{G}.
This standardisation corresponds to diagonalising \eqn{A}
where the eigenvalues of \eqn{A} become the diagonal elements of the new \eqn{A}.
The diagonal elements of the new \eqn{A} are then estimated using score matching, with the final diagonal element calculated from the sum of the other elements.
See \insertCite{mardia2016sc;textual}{scorematchingad} for details.
}
\examples{
p <- 4
A <- rsymmetricmatrix(p)
A[p,p] <- -sum(diag(A)[1:(p-1)]) #to satisfy the trace = 0 constraint
if (requireNamespace("simdd")){
  Y <- simdd::rBingham(100, A)
  Bingham(Y, method = "Mardia")
}
}
\references{
\insertAllCited{}
}
\seealso{
Other directional model estimators: 
\code{\link{FB}()},
\code{\link{vMF}()},
\code{\link{vMF_robust}()}
}
\concept{directional model estimators}
