% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woebin.R
\name{woebin_adj}
\alias{woebin_adj}
\title{WOE Binning Adjustment}
\usage{
woebin_adj(dt, y, bins, all_var = TRUE, count_distr_limit = 0.05)
}
\arguments{
\item{dt}{A data frame.}

\item{y}{Name of y variable.}

\item{bins}{A list or data frame. Binning information generated from \code{woebin}.}

\item{all_var}{Logical, default is TRUE. If it is TRUE, the variables that need to adjust breaks include all variables, otherwise, include the variables that number distribution rate less then count_distr_limit or more then one inflection point.}

\item{count_distr_limit}{The count_distr limit to adjust binning breaks. Default 0.05.}
}
\description{
\code{woebin_adj} interactively adjust the binning breaks.
}
\examples{
\dontrun{
# Load German credit data
data(germancredit)

# Example I
dt = germancredit[, c("creditability", "age.in.years", "credit.amount")]
bins = woebin(dt, y="creditability")
breaks_adj = woebin_adj(dt, y="creditability", bins)
bins_final = woebin(dt, y="creditability",
                    breaks_list=breaks_adj)

# Example II
binsII = woebin(germancredit, y="creditability")
breaks_adjII = woebin_adj(germancredit, "creditability", binsII)
bins_finalII = woebin(germancredit, y="creditability",
                    breaks_list=breaks_adjII)
}

}
\seealso{
\code{\link{woebin}}, \code{\link{woebin_ply}}, \code{\link{woebin_plot}}
}
