% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woebin.R
\name{woebin}
\alias{woebin}
\title{WOE Binning}
\usage{
woebin(dt, y, x = NULL, breaks_list = NULL, min_perc_total = 0.02,
  stop_limit = 0.1, max_bin_num = 6, positive = "bad|1",
  no_cores = NULL, print_step = 0L)
}
\arguments{
\item{dt}{A data frame with both x (predictor/feature) and y (response/label) variables.}

\item{y}{Name of y variable.}

\item{x}{Name of x variables. Default is NULL. If x is NULL, then all variables except y are counted as x variables.}

\item{breaks_list}{List of break points, defaults NULL If it is not NULL, variable binning will based on the provided breaks.}

\item{min_perc_total}{The share of initial binning class number over total. Accepted range: 0.01-0.2; default 0.02.}

\item{stop_limit}{Stop binning segmentation when information value gain ratio less than the stop_limit. Accepted range: 0-0.5; default 0.1.}

\item{max_bin_num}{Integer. The maximum binning number.}

\item{positive}{Value of positive class, default "bad|1".}

\item{no_cores}{Number of CPU cores for parallel computation. Defaults NULL. If no_cores is NULL, the no_cores will set as 1 if length of x variables less than 20, and will set as the number of all CPU cores if the length of x variables greater than or equal to 20.}

\item{print_step}{A non-negative integer. Default is 1. If print_step>0, print variable names by each print_step-th iteration. If print_step=0 or no_cores>1, no message is print.}
}
\value{
Optimal or customized binning information
}
\description{
\code{woebin} generates optimal binning using tree-like segmentation for numerical, factor and categorical variables. \code{woebin} can also customizing breakpoints if the breaks_list was provided.
}
\examples{
# load germancredit data
data(germancredit)

# Example I
# binning of two variables in germancredit dataset
bins_2var = woebin(germancredit, y = "creditability", x = c("credit.amount", "purpose"))

\dontrun{
# Example II
# binning of the germancredit dataset
bins_germ = woebin(germancredit, y = "creditability")
# converting bins_germ into a dataframe
# bins_germ_df = data.table::rbindlist(bins_germ)

# Example III
# customizing the breakpoints of binning
breaks_list = list(
  age.in.years = c(26, 35, 37),
  credit.amount = NULL,
  housing = c("own", "for free\%,\%rent"),
  purpose = NULL
)

bins_cus_brk = woebin(germancredit, y="creditability",
  x=c("age.in.years", "credit.amount", "housing", "purpose"),
  breaks_list=breaks_list)
}

}
\seealso{
\code{\link{woebin_ply}}, \code{\link{woebin_plot}}, \code{\link{woebin_adj}}
}
