% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotRanking}
\alias{plotRanking}
\title{Ranking Plots}
\usage{
plotRanking(pvalues, summary, alpha = 0.05, cex = 0.75,
  decreasing = FALSE)
}
\arguments{
\item{pvalues}{Matrix or data frame with the p-values used to determine the differences}

\item{summary}{Summary values used to place the algorithms. Typically it will be the average ranking, but it can be any other value}

\item{alpha}{Significance level to determine the significativity of the differences. By default this value is 0.05}

\item{cex}{Numeric value to control the size of the font. By default it is set at 0.75.}

\item{decreasing}{A logical value to determine whether the values have to be plotter from smaller to larger or the other way round.}
}
\description{
This function creates a plot similar to the critical difference plot, but applicable to any corrected pvalue.
}
\examples{
data(data_gh_2008)
test <- postHocTest(data.gh.2008, test="friedman", correct="bergmann", use.rank=TRUE)
plotRanking(pvalues=test$corrected.pval, summary=test$summary, alpha=0.05)

}
\seealso{
\code{\link{drawAlgorithmGraph}}, \code{\link{plotCD}}, \code{\link{plotPvalues}}
}

