% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color-spaces.R
\name{hsv_to_hsl}
\alias{hsv_to_hsl}
\title{Convert HSV to HSL}
\usage{
hsv_to_hsl(hsv)
}
\arguments{
\item{hsv}{A dataframe or matrix with H, S and V colour channels located in the columns 1 to 3, respectively. H in degrees in [0, 360], S and L in [0, 1]}
}
\value{
A \code{tibble} of H, S and L colour channels. Hue is constant between colour spaces, while saturation differs.
}
\description{
Convert HSV to HSL
}
\examples{
H <- sample(x = 0:360, size = 10, replace = TRUE)
S <- runif(n = 10)
V <- runif(n = 10)
hsv_to_hsl(data.frame(h = H, s = S, v = V))
}
