% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataIO.R
\name{ExportSeurat}
\alias{ExportSeurat}
\title{Export SeuratObject to Other Formats.}
\usage{
ExportSeurat(
  seu.obj,
  assay = NULL,
  reduction = NULL,
  to = c("SCE", "AnnData", "CellDataSet", "cell_data_set", "loom"),
  anndata.file = NULL,
  loom.file = NULL,
  conda.path = NULL,
  ...
)
}
\arguments{
\item{seu.obj}{A seurat object.}

\item{assay}{Which assay to use. Default: NULL (get with \code{\link{DefaultAssay}}).}

\item{reduction}{Name of DimReduc to set to main reducedDim in cds.}

\item{to}{The target format, chosen from "SCE" (SingleCellExperiment), "AnnData", "CellDataSet", "cell_data_set", "loom".
Default: "SCE".}

\item{anndata.file}{File used to save AnnData results. Default: NULL.}

\item{loom.file}{File used to save loom results. Default: NULL.}

\item{conda.path}{Conda environment path, used when \code{to} is "AnnData". Default: NULL.}

\item{...}{Parameter for \code{\link{as.SingleCellExperiment}}, \code{sceasy::convertFormat}, \code{\link{as.CellDataSet}},
\code{as.cell_data_set}, \code{SaveLoom}, corresponding to \code{to}.}
}
\value{
Object corresponding to \code{to}.
}
\description{
Export SeuratObject to Other Formats.
}
\examples{
\dontrun{
library(Seurat)
# export to SingleCellExperiment
sce.obj <- ExportSeurat(seu.obj = pbmc_small, assay = "RNA", to = "SCE")
# export to CellDataSet
cds.obj <- ExportSeurat(seu.obj = pbmc_small, assay = "RNA", reduction = "tsne", to = "CellDataSet")
# export to cell_data_set
cds3.obj <- ExportSeurat(seu.obj = pbmc_small, assay = "RNA", to = "cell_data_set")
# export to AnnData, need users to provide the conda path and the output file
ExportSeurat(
  seu.obj = pbmc_small, assay = "RNA", to = "AnnData", conda.path = "/path/to/anaconda3",
  anndata.file = "/path/to/pbmc_small.h5ad"
)
# export to loom, need users to provide the output file
ExportSeurat(
  seu.obj = pbmc_small, assay = "RNA", to = "loom",
  loom.file = "/path/to/pbmc_small.loom"
)
}
}
