% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_plot.R
\name{raw_plot}
\alias{raw_plot}
\title{Plot Raw Data with Optional Phase and Condition Annotations}
\usage{
raw_plot(
  .df,
  .out,
  .time,
  .phase = NULL,
  .cond = NULL,
  .participant = NULL,
  phase_levels = NULL,
  phase_labels = NULL,
  cond_levels = NULL,
  cond_labels = NULL,
  label_raise = 2
)
}
\arguments{
\item{.df}{A data frame containing the data to be plotted. Must contain columns
specified by .time, .out, and optionally .phase, .cond, and .participant
if used.}

\item{.out}{The name of the column in .df that contains the outcome variable
to be plotted on the y-axis.}

\item{.time}{The name of the column in .df that contains the time variable to
be plotted on the x-axis.}

\item{.phase}{(Optional) The name of the column in .df that contains the phase
variable used for annotating the plot with phase changes. If NULL,
phase annotations are not added.}

\item{.cond}{(Optional) The name of the column in .df that contains the condition
variable. If not NULL, data points are colored based on condition.}

\item{.participant}{(Optional) The name of the column in .df that contains
participant identifiers. If not NULL, the plot is faceted
by participant.}

\item{phase_levels}{(Optional) A vector of values indicating the order of phase
levels. This is used to set the factor levels of the phase
variable.}

\item{phase_labels}{(Optional) A vector of labels corresponding to the phase
levels. These labels are used in annotations.}

\item{cond_levels}{(Optional) A vector of values indicating the order of condition
levels. This is used to set the factor levels of the condition
variable.}

\item{cond_labels}{(Optional) A vector of labels corresponding to the condition
levels. These are used for the legend.}

\item{label_raise}{A numeric value indicating how much to raise the phase labels
on the y-axis. Defaults to 2.}
}
\value{
A ggplot object representing the raw data plot with optional annotations
for phase and condition, and faceting by participant if specified.
}
\description{
This function generates a plot of raw data from a specified data frame. It
supports optional annotations based on phase and condition variables, and can
facet the plot by participant. The plot is customizable with parameters for
setting factor levels and labels for both phase and condition variables. It
utilizes ggplot2 for plotting.
}
\examples{
rp <- raw_plot(.df = efficacy_of_CBT, .out = "Anxious", .time = "time",
               .phase = "phase", phase_levels = c(0, 1),
               phase_labels = c("Exposure", "Exposure + CT"))

}
