% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{propagateLabelsDiffusion}
\alias{propagateLabelsDiffusion}
\title{Estimate labeling distribution for each vertex, based on provided labels using a Random Walk on graph}
\usage{
propagateLabelsDiffusion(
  graph,
  labels,
  max.iters = 100,
  diffusion.fading = 10,
  diffusion.fading.const = 0.1,
  tol = 0.025,
  fixed.initial.labels = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{graph}{igraph graph object Graph input}

\item{labels}{vector of factor or character labels, named by cell names}

\item{max.iters}{integer Maximal number of iterations (default=100)}

\item{diffusion.fading}{numeric Constant used for diffusion on the graph, exp(-diffusion.fading * (edge_length + diffusion.fading.const)) (default=10.0)}

\item{diffusion.fading.const}{numeric Another constant used for diffusion on the graph, exp(-diffusion.fading * (edge_length + diffusion.fading.const)) (default=0.1)}

\item{tol}{numeric Absolute tolerance as a stopping criteria (default=0.025)}

\item{fixed.initial.labels}{boolean Prohibit changes of initial labels during diffusion (default=TRUE)}

\item{verbose}{boolean Verbose mode (default=TRUE)}
}
\value{
matrix from input graph, with labels propagated
}
\description{
Estimate labeling distribution for each vertex, based on provided labels using a Random Walk on graph
}
\examples{
propagateLabelsDiffusion(conosGraph, labels=cellAnnotations)

}
