% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evt.R
\name{evt.extract_header}
\alias{evt.extract_header}
\title{Extract header from evt file.}
\usage{
evt.extract_header(filename)
}
\arguments{
\item{filename}{The filename}
}
\value{
A string containing the header
}
\description{
Extract header from evt file.
}
\examples{

infile <- system.file("extdata", "example1_tac.evt", package = "scbursts")

# Get Dwells
transitions <- evt.read(infile)
dwells <- evt.to_dwells(transitions)
dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")

# Get Header
header <- evt.extract_header(infile)

evt.write(dwells_c, header=header, file=file.path(tempdir(), "fixed_example1_tac.evt"))
}
