% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bursts.R
\name{bursts.space_out}
\alias{bursts.space_out}
\title{Artificially add amount of time between bursts (in absence of recording information).}
\usage{
bursts.space_out(segments, sep_factor = 1000)
}
\arguments{
\item{segments}{The segments to space out}

\item{sep_factor}{the factor by which to separate the segments.
Either the factor in seconds, or a multiple of the longest observed dwell.}
}
\value{
The segments again, but with modified meta-data.
}
\description{
Given a list of segments separated by an unknown amount of time, one may want to space the segments by some amount of time, so that they can be plotted. This function takes a separating factor, and splits up the segments by either that factor (in seconds), or that many multiples of the largest observed dwell.
}
\examples{
infile <- system.file("extdata", "example2_qub.dwt", package = "scbursts")
dwells <- dwt.read(infile)

# Still a list, but the meta-data is fixed
spaced_records <- bursts.space_out(dwells, sep_factor=1000)

# Combine them, and they'll be nicely spaced out.
single_record <- bursts.recombine(spaced_records)

# You can now plot that single_record using one of the plot functions.

}
