% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bursts.R
\name{bursts.pcloseds}
\alias{bursts.pcloseds}
\title{Return pcloseds of every burst.}
\usage{
bursts.pcloseds(bursts)
}
\arguments{
\item{bursts}{The list of all bursts}
}
\value{
The pclosed values
}
\description{
Return pcloseds of every burst.
}
\examples{

infile <- system.file("extdata", "example1_qub.dwt", package = "scbursts")
dwells <- dwt.read(infile)
dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")
bursts <- bursts.defined_by_tcrit(dwells_c, 100, units="ms")

pcloseds <- bursts.popens(bursts)
hist(pcloseds)

}
