% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_scatterpie.R
\name{geom_scatterpie}
\alias{geom_scatterpie}
\title{geom_scatterpie}
\usage{
geom_scatterpie(
  mapping = NULL,
  data,
  cols,
  pie_scale = 1,
  sorted_by_radius = FALSE,
  legend_name = "type",
  long_format = FALSE,
  donut_radius = NULL,
  bg_circle_radius = NULL,
  ...
)
}
\arguments{
\item{mapping}{aes mapping}

\item{data}{data}

\item{cols}{cols the pie data}

\item{pie_scale}{amount to scale the pie size if there is no radius mapping exists}

\item{sorted_by_radius}{whether plotting large pie first}

\item{legend_name}{name of fill legend}

\item{long_format}{logical whether use long format of input data}

\item{donut_radius}{numeric the radius of donut chart (relative the radius of circle), default is NULL.
it should be between 0 and 1, if it is provided, the donut chart will be displayed instead of pie chart.}

\item{bg_circle_radius}{numeric the radius of background circle, default is FALSE, we suggest setting it 
to between 1 and 1.5 .}

\item{...}{additional parameters}
}
\value{
layer
}
\description{
scatter pie plot
}
\examples{
library(ggplot2)
d <- data.frame(x=rnorm(5), y=rnorm(5))
d$A <- abs(rnorm(5, sd=1))
d$B <- abs(rnorm(5, sd=2))
d$C <- abs(rnorm(5, sd=3))
ggplot() + geom_scatterpie(aes(x=x, y=y), data=d, cols=c("A", "B", "C")) + coord_fixed()
d <- tidyr::gather(d, key="letters", value="value", -x:-y)
ggplot() + geom_scatterpie(aes(x=x, y=y), data=d, cols="letters", long_format=TRUE) + coord_fixed()
p1 <- ggplot() + 
      geom_scatterpie(
        mapping = aes(x=x, y=y), data=d, cols="letters", 
        long_format=TRUE, 
        donut_radius=.5
      ) + 
      coord_fixed()
p1
p2 <- ggplot() + 
      geom_scatterpie(
        mapping = aes(x=x, y=y), data=d, cols="letters", 
        long_format=TRUE, 
        donut_radius = .5, 
        bg_circle_radius = 1.2
      ) + 
      coord_fixed()
p2
}
\author{
Guangchuang Yu
}
