% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genesetCytoSig.R
\name{genesetCytoSig}
\alias{genesetCytoSig}
\title{CytoSig gene set construction.}
\usage{
genesetCytoSig(cytokine.eval, file.name)
}
\arguments{
\item{cytokine.eval}{Cytokine(s) associated with the query.}

\item{file.name}{List of XML file(s) associated with the cytokine(s) beginning with the specific cytokine name.}
}
\value{
Dataframe consisting of genes and the associated log2 fold change values associated with the specific cytokine(s).
}
\description{
Returns the gene set associated with input cytokine(s) from the CytoSig database
given manually specified cytokine-specific output csv file(s) under
the extdata directory with file name beginning with
the specified cytokine (i.e., 'IL6_output.csv') as currently provided for the IL6 cytokine.
}
\examples{
file.name.cytosig1 <- system.file("extdata", "IL6_output.csv", package = "scaper")
genesetCytoSig(cytokine.eval = "IL6", file.name = file.name.cytosig1) \%>\% head(10)
}
