% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.scdf.R
\name{plot.scdf}
\alias{plot.scdf}
\alias{plotSC}
\title{Plot single-case data}
\usage{
\method{plot}{scdf}(...)

plotSC(
  data,
  dvar,
  pvar,
  mvar,
  ylim = NULL,
  xlim = NULL,
  xinc = 1,
  lines = NULL,
  marks = NULL,
  phase.names = NULL,
  xlab = NULL,
  ylab = NULL,
  main = "",
  case.names = NULL,
  style = getOption("scan.plot.style"),
  ...
)
}
\arguments{
\item{...}{Further arguments passed to the plot command.}

\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about this format.}

\item{dvar}{Character string with the name of the dependent variable. Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable. Defaults to the attributes in the scdf file.}

\item{ylim}{Lower and upper limits of the y-axis (e.g., \code{ylim = c(0,
20)} sets the y-axis to a scale from 0 to 20). With multiple single-cases
you can use \code{ylim = c(0, NA)} to scale the y-axis from 0 to the maximum
of each case. \code{ylim} is not set by default, which makes \code{scan} set
a proper scale based on the given data.}

\item{xlim}{Lower and upper limits of the x-axis (e.g., \code{xlim = c(0,
20)} sets the x-axis to a scale from 0 to 20). With multiple single-cases
you can use \code{ylim = c(0, NA)} to scale the x-axis from 0 to the maximum
of each case. \code{xlim} is not set by default, which makes \code{scan} set
a proper scale based on the given data.}

\item{xinc}{An integer. Increment of the x-axis. 1 :each mt value will be printed, 2 : every other value, 3 : every third values etc.}

\item{lines}{A character or list defining one or more lines or curves to be
plotted. The argument is either passed as a character string (e.g.,
\code{lines = "median"}) or as a list (e.g., \code{list("median", "trend")}.
Some of the procedures can be refined with an additional argument (e.g.,
\code{lines = list("mean" = 0.20)} adds a 20\% trimmed mean line. By default
no additional lines are plotted. Possible lines are: \itemize{
\item\code{"median"} Separate lines for phase A and B medians.
\item\code{"mean"} Separate lines for phase A and B means. By default it is
10\%-trimmed. Other trims can be set, using a second parameter (e.g.,
\code{lines = list(mean = 0.2)} draws a 20\%-trimmed mean line).
\item\code{"trend"} Separate lines for phase A and B trends.
\item\code{"trendA"} Trend line for phase A, extrapolated throughout phase
B.  \item\code{"maxA/minA"} Line at the level of the highest or lowest phase A score.
\item\code{"medianA"} Line at the phase A median score.  \item\code{"meanA"}
Line at the phase A 10\%-trimmed mean score. Apply a different trim, by
using the additional argument (e.g., \code{lines = list(meanA = 0.2)}).
\item\code{"plm"} Regression lines for piecewise linear regression model.
\item\code{"plm.ar"} Regression lines for piecewise autoregression model.
The lag is specified like this: \code{lines = list(plm.ar = 2)}. Default lag is set to 2.
\item\code{"movingMean"} Draws a moving mean curve, with a specified lag:
\code{lines = list(movingMean = 2)}. Default is a lag 1 curve.
\item\code{"movingMedian"} Draws a moving median curve, with a specified
lag: \code{lines = list(movingMedian = 3)}. Default is a lag 1 curve.
\item\code{"loreg"} Draws a non-parametric local regression line. The
proportion of data influencing each data point can be specified using
\code{lines = list("loreg" = 0.66)}. The default is 0.5.  \item\code{"lty"}
Use this argument to define the line type. Examples are: \code{"solid"},
\code{"dashed"}, \code{"dotted"}.  \item\code{"lwd"} Use this argument to
define the line's thickness, e.g., \code{lwd = 4}.  \item\code{"col"} Use
this argument to define the line's color, e.g., \code{col = "red"}.  }}

\item{marks}{A list of parameters defining markings of certain data points.
\itemize{ \item\code{"positions"} A vector or a list of vectors indicating
measurement-times to be highlighted. In case of a vector, the marked
measurement-times are the same for all plotted cases. In case of a list of
vectors, marks are set differently for each case. The list must have the
same length as there are cases in the data file.  \item\code{"col"} Color of
the marks.  \item\code{"cex"} Size of the marks.  } Use for example
\code{marks = list(positions = c(1, 8, 15), col = "red", cex = 3)} to make
the MTs one, eight and 18 appear big and red.}

\item{phase.names}{By default phases are labeled based on the levels of the phase variable. 
Use this argument to specify different labels: \code{phase.names = c("Baseline",
"Intervention")}.}

\item{xlab}{The label of the x-axis. Default is \code{xlab = "Measurement
time"}.}

\item{ylab}{The labels of the y-axis. Default is \code{ylab = "Score"}.}

\item{main}{Main title of the plot.}

\item{case.names}{Case names. If not provided, names are taken from the scdf.
Set \code{case.names = ""} if you don't like to include case names.}

\item{style}{Either a character with the name of a pre-implemented style or a style object. See \code{\link{style_plot}} to learn about this format.}
}
\value{
Returns a plot of one or multiple single-cases.
}
\description{
This function provides a plot of a single-case or multiple
single-cases.
}
\examples{

## Request the default plot of the data from Borckhardt (2014)
plot(Borckardt2014)

## Plot the three cases from Grosche (2011) and visualize the phase A trend
plot(Grosche2011, style = "grid", lines = "trendA")

## Request the local regression line for Georg from that data set and customize the plot
plot(Grosche2011$Georg, style = "sienna", ylim = c(0,NA),
       xlab = "Training session", ylab = "Words per minute",
       phase.names = c("Baseline", "Intervention"), 
       lines = list("loreg", lty = "solid", col = "black", lwd = 3))

## Plot a random MBD over three cases and mark interesting MTs
dat <- rSC(design = design_rSC(3))
plot(dat, marks = list(positions = list(c(2,4,5),c(1,2,3),c(7,8,9)), col = "blue",
       cex = 1.4), style = c("grid", "annotate", "tiny"))

}
\seealso{
\code{\link{style_plot}}, \code{\link{describeSC}}, \code{\link{overlapSC}}
}
\author{
Juergen Wilbert
}
