% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rSC.R
\name{random}
\alias{random}
\alias{rSC}
\alias{design_rSC}
\title{Single-case data generator}
\usage{
rSC(design = NULL, round = NA, random.names = FALSE, seed = NULL,
  ...)

design_rSC(n = 1, phase.design = list(A = 5, B = 15),
  trend = list(0), level = list(0), slope = list(0),
  rtt = list(0.8), m = list(50), s = list(10), extreme.p = list(0),
  extreme.d = c(-4, -3), missing.p = list(0),
  distribution = "normal", prob = 0.5, MT = NULL, B.start = NULL)
}
\arguments{
\item{design}{A design matrix which is created by design_rSC and specifies
all paramters.}

\item{round}{Rounds the scores to the defined decimal. To round to the second
decimal, set \code{round = 2}.}

\item{random.names}{Is \code{FALSE} by default. If set \code{random.names =
TRUE} cases are assigned random first names. If set \code{"male" or
"female"} only male or female names are chosen. The names are drawn from
the 2,000 most popular names for newborns in 2012 in the U.S. (1,000 male
and 1,000 female names).}

\item{seed}{A seed number for the random generator.}

\item{...}{Paramteres that are directly passed from the rSC function to the design_rSC function for a more concise coding.}

\item{n}{Number of cases to be created (Default is \code{n = 1}).}

\item{phase.design}{A vector defining the length and label of each phase.
E.g., \code{phase.length = c(A1 = 10, B1 = 10, A2 = 10, B2 = 10)}.}

\item{trend}{Defines the effect size \emph{d} of a trend per MT added
across the whole data-set. To assign different trends to several
single-cases, use a vector of values (e.g. \code{trend = c(.1, .3, .5)}).
If the number of cases exceeds the length of the vector, values are
repeated. While using a binomial or poisson distribution, \code{d.trend}
indicates an increase in points / counts per MT.}

\item{level}{Defines the level increase (effect size \emph{d}) at the
beginning of phase B. To assign different level effects to several
single-cases, use a vector of values (e.g. \code{d.level = c(.2, .4, .6)}).
If the number of cases exceeds the length of the vector, values are
repeated. While using a binomial or poisson distribution, \code{d.level}
indicates an increase in points / counts with the onset of the B-phase.}

\item{slope}{Defines the increase in scores - starting with phase B -
expressed as effect size \emph{d} per MT. \code{d.slope = .1} generates an
incremental increase of 0.1 standard deviations per MT for all phase B
measurements. To assign different slope effects to several single-cases,
use a vector of values (e.g. \code{d.slope = c(.1, .2, .3)}). If the number
of cases exceeds the length of the vector, values are repeated. While using
a binomial or poisson distribution, \code{d.slope} indicates an increase in
points / counts per MT.}

\item{rtt}{Reliability of the underlying simulated measurements. Set
\code{rtt = .8} by default. To assign different reliabilities to several
single-cases, use a vector of values (e.g. \code{rtt = c(.6, .7, .8)}). If
the number of cases exceeds the length of the vector, values are repeated.
\code{rtt} has no effect when you're using binomial or poisson distributed
scores.}

\item{m}{Mean of the sample distribution the scores are drawn from. Default
is \code{m = 50}. To assign different means to several single-cases, use a
vector of values (e.g. \code{m = c(50, 42, 56)}). If the number of cases
exceeds the length of the vector, values are repeated.}

\item{s}{Standard deviation of the sample distribution the scores are drawn
from. Set to \code{s = 10} by default. To assign different variances to
several single-cases, use a vector of values (e.g. \code{s = c(5, 10,
15)}). If the number of cases exceeds the length of the vector, values are
repeated.}

\item{extreme.p}{Probability of extreme values. \code{extreme.p = .05} gives
a five percent probability of an extreme value. A vector of values assigns
different probabilities to multiple cases. If the number of cases exceeds
the length of the vector, values are repeated.}

\item{extreme.d}{Range for extreme values, expressed as effect size \emph{d}.
\code{extreme.d = c(-7,-6)} uses extreme values within a range of -7 and -6
standard deviations. In case of a binomial or poisson distribution,
\code{extreme.d} indicates points / counts. Caution: the first value must
be smaller than the second, otherwise the procedure will fail.}

\item{missing.p}{Portion of missing values. \code{missing.p = 0.1} creates
10\% of all values as missing). A vector of values assigns different
probabilities to multiple cases. If the number of cases exceeds the length
of the vector, values are repeated.}

\item{distribution}{Distribution of the scores. Default is \code{distribution
= "normal"}. Possible values are \code{"normal"}, \code{"binomial"}, and
\code{"poisson"}. If set to \code{"normal"}, the sample of scores will be
normally distributed with the parameters \code{m} and \code{s} as mean and
standard deviation of the sample, including a measurement error defined by
\code{rtt}. If set to \code{"binomial"}, data are drawn from a binomial
distribution with the expectation value \code{m}. This setting is useful
for generating criterial data like correct answers in a test. If set to
\code{"poisson"}, data are drawn from a poisson distribution, which is very
common for count-data like behavioral observations. There's no measurement
error is included. \code{m} defines the expectation value of the poisson
distribution, lambda.}

\item{prob}{If \code{distribution} (see below) is set \code{"binomial"},
\code{prob} passes the probability of occurrence.}

\item{MT}{Number of measurements (in each study). Default is \code{MT = 20}.}

\item{B.start}{Phase B starting point. The default setting \code{B.start = 6}
would assign the first five scores (of each case) to phase A, and all
following scores to phase B. To assign different starting points for a set
of multiple single-cases, use a vector of starting values (e.g.
\code{B.start = c(6, 7, 8)}). If the number of cases exceeds the length of
the vector, values will be repeated.}
}
\value{
A single-case data frame. See \code{\link{scdf}} to learn about this format.
}
\description{
The \code{rSC} function generates random single-case data frames
for monte-carlo studies and demonstration purposes.
\code{design_rSC} is used to set up a design matrix with all parameters needed for the \code{rSC} function.
}
\examples{

## Create random single-case data and inspect it
design <- design_rSC(
  n = 3, rtt = 0.75, slope = 0.1, extreme.p = 0.1,
  missing.p = 0.1
)
dat <- rSC(design, round = 1, random.names = TRUE, seed = 123)
describeSC(dat)
plotSC(dat)

## And now have a look at poisson-distributed data
design <- design_rSC(
  n = 3, B.start = c(6, 10, 14), MT = c(12, 20, 22), m = 10,
  distribution = "poisson", level = -5, missing.p = 0.1
)
dat <- rSC(design, seed = 1234)
pand(dat, decreasing = TRUE, correction = FALSE)
}
\author{
Juergen Wibert
}
\keyword{datagen}
