% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_reviewNeurons.R
\name{reviewNeurons}
\alias{reviewNeurons}
\title{Manually classify the identified neurons from SCALPEL.}
\usage{
reviewNeurons(
  scalpelOutput,
  neuronSet,
  keepClusterSize = NULL,
  discardZeroedOut = FALSE
)
}
\arguments{
\item{scalpelOutput}{An object returned by one of the SCALPEL functions:
\code{\link{scalpel}}, \code{\link{scalpelStep2}}, or \code{\link{scalpelStep3}}.}

\item{neuronSet}{The set of neurons that should be reviewed:
use \code{"A"} for those resulting from \code{\link{scalpelStep2}} and saved as \code{scalpelOutput$A}, or use \code{"Afilter"} for those resulting from
\code{\link{scalpelStep3}} and saved as \code{scalpelOutput$Afilter}. This argument is ignored if the class of \code{scalpelOutput} is \code{scalpelStep2}.}

\item{keepClusterSize}{Neurons corresponding to clusters with at least \code{keepClusterSize} members will be automatically classified as real neurons.
The default value is \code{NULL}, which means that none of the neurons will be automatically kept based on cluster size.}

\item{discardZeroedOut}{Logical value indicating whether neurons zeroed out in the sparse group lasso problem should automatically be discarded. This argument
is ignored when \code{neuronSet} is \code{"A"}, and has a default value of \code{FALSE}.}
}
\value{
None
}
\description{
We save plots that will be used to review the set of identified neurons that result from either Step 2 or 3 of SCALPEL in order to manually classify them according
to whether they appear to be real neurons or not. To do this, the plot of the frame from which the dictionary element was derived is saved.
The user can then sort these saved plot into folders indicating whether the neuron is real or not, or indicate that additional frames are needed to make the classification, in which
case the \code{\link{reviewNeuronsMoreFrames}} function can subsequently be used. After finishing this sorting process, \code{\link{updateNeurons}} should be called.
A similar manual classification can be done interactively using \code{\link{reviewNeuronsInteractive}}.
}
\details{
Plots are saved for each of the neurons under consideration in a certain folder. Also within that folder,
there will be folders called 'keep', 'discard', and 'unsure'. After running this function, the plots for each of the neurons
should be moved into the appropriate folder. After completing this sorting, call \code{\link{updateNeurons}} in order to
update the classification of the neurons. Any plots that are missing or that remain in the original folder will be classified as not having been sorted yet.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function

#we review the set of spatial components from Step 3,
#which are contained in scalpelOutput$Afilter
reviewNeurons(scalpelOutput = scalpelOutput, neuronSet = "Afilter")
}
}
\seealso{
After sorting the plots saved by this function, the user should call \code{\link{updateNeurons}}.
For other functions useful in the classification process, see \code{\link{reviewNeuronsMoreFrames}} and
\code{\link{reviewOverlappingNeurons}}. Once classification is finished,
the argument \code{neuronsToOutline="kept"} can be used with \code{\link{plotBrightest}} and \code{\link{plotVideoVariance}},
and the argument \code{neuronsToDisplay="kept"} can be used with \code{\link{plotResults}}, \code{\link{plotResultsAllLambda}},
 \code{\link{plotTemporal}}, and \code{\link{plotSpatial}}. Finally, the argument \code{excludeReps="discarded"} allows
 the discarded dictionary elements to be excluded from the sparse group lasso model when running \code{\link{scalpelStep3}}.
}
