% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scStability-package.R
\docType{package}
\name{scStability-package}
\alias{scStability-package}
\title{scStability: Measuring the Stability of Dimension Reduction and Cluster Assignment in scRNA-Seq}
\description{
The scStability package provides functions for evaluating the stability of low-dimensional embeddings and cluster assignments in single‑cell RNA sequencing (scRNA‑seq) datasets. Starting from a principal component analysis (PCA) object, users can generate multiple replicates of t‑Distributed Stochastic Neighbor Embedding (t‑SNE) or Uniform Manifold Approximation and Projection (UMAP) embeddings. Embedding stability is quantified by computing pairwise Kendall’s Tau correlations across replicates and summarizing the distribution of correlation coefficients. In addition to dimensionality reduction, scStability assesses clustering consistency using either Louvain or Leiden and calculating the Normalized Mutual Information (NMI) between all pairs of cluster assignments. For background on UMAP and t-SNE algorithms, see McInnes et al. (2020, \doi{10.21105/joss.00861}) and van der Maaten & Hinton (2008, *JMLR*; \url{https://lvdmaaten.github.io/tsne/}), respectively.
}
\author{
\strong{Maintainer}: Ben Abrahams \email{ben.abrahams.de@gmail.com}

}
\keyword{internal}
