% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_genes_cell.R
\name{extract_genes_cell}
\alias{extract_genes_cell}
\title{Extract Markers}
\usage{
extract_genes_cell(
  geneHeat,
  cellTypes = "ALL",
  val = 1,
  isMax = FALSE,
  isPvalue = FALSE
)
}
\arguments{
\item{geneHeat}{The heatmap of ranks from your scRNA-seq dataset with your genes subsetted.}

\item{cellTypes}{The cell-types that you're interested in extracting. They need to be colnames (not case sensitive).}

\item{val}{How associated a gene is with a particualr cell type to include in your list - default is slightly associated.}

\item{isMax}{If you are taking the single best CT marker (T/F) -- TRUE not recommended.}

\item{isPvalue}{If the signature matrix is raw p-value (T/F) -- TRUE not recommended.}
}
\value{
\code{extract_genes_cell} A vector of genes above the threshold for each sample. \cr
}
\description{
Extracting cell-type markers from a signature matrix.
}
\details{
This function takes a signature matrix and 
extracts cell-type markers above a p-value or fold-change threshold.
}
\examples{


data(POA_example)
Signature <- POA_example$POA_Rank_signature
RowName <- get_gene_symbol(Signature)
rownames(Signature) <-RowName$rowname
# extract genes with a -log10(Padj > 1)
Signat <- extract_genes_cell(Signature)



}
