% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCR.ClonotypeComposition.R
\name{BCR.ClonotypeComposition}
\alias{BCR.ClonotypeComposition}
\title{The composition of single-cell BCR clonotypes in the sample}
\usage{
BCR.ClonotypeComposition(contigList, sampleName)
}
\arguments{
\item{contigList}{The product of BCR.ContigList().}

\item{sampleName}{The sample name of single cell sample.}
}
\value{
Multiple pictures in the form of a list.
}
\description{
The composition of single-cell BCR clonotypes in the sample
}
\examples{

project_data_dir <- "F:/R_Language/data/bcr"
sample_name <- list.dirs(project_data_dir, full.names = FALSE, recursive = FALSE)
group_name <- c("A", "A", "B", "B")
contig_list <- BCR.ContigList(project_data_dir, sample_name, group_name)

BasicPlot(BCR.ClonotypeComposition, contig_list, sample_name)
}
