% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_jackstraw.R
\name{get_lm_pvals}
\alias{get_lm_pvals}
\title{Compute gene-factor associations using univariate linear models}
\usage{
get_lm_pvals(container, n.cores = container$experiment_params$ncores)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{n.cores}{Number of cores to use (default = container$experiment_params$ncores)}
}
\value{
The project container with a vector of adjusted p-values for the gene-factor
associations in container$gene_score_associations.
}
\description{
Compute gene-factor associations using univariate linear models
}
\examples{
test_container <- get_lm_pvals(test_container, n.cores=1)
}
