% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{Meta_Present}
\alias{Meta_Present}
\title{Check if meta data are present}
\usage{
Meta_Present(
  seurat_object,
  meta_col_names,
  print_msg = TRUE,
  omit_warn = TRUE,
  abort = TRUE
)
}
\arguments{
\item{seurat_object}{object name.}

\item{meta_col_names}{vector of column names to check.}

\item{print_msg}{logical. Whether message should be printed if all features are found.  Default is TRUE.}

\item{omit_warn}{logical. Whether to print message about features that are not found in current object. Default is TRUE.}

\item{abort}{logical. Whether or not to stop function and print stop message if no input \code{meta_col_names} are found.  Default is TRUE.}
}
\value{
vector of meta data columns that are present
}
\description{
Check if meta data columns are present in object and return vector of found columns
Return warning messages for meta data columns not found.
}
\examples{
\dontrun{
meta_variables <- Meta_Present(seurat_object = obj_name, gene_list = DEG_list, print_msg = TRUE)
}

}
\concept{helper_util}
