% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_pe.r
\name{plot_sampled_2d_ple}
\alias{plot_sampled_2d_ple}
\title{Plot 2D profile likelihood estimations.}
\usage{
plot_sampled_2d_ple(df, parameter1, parameter2, fileout, title = "",
  logspace = TRUE, scientific_notation = TRUE)
}
\arguments{
\item{df}{the data set containing the parameter estimates to plot.}

\item{parameter1}{the name of the first parameter}

\item{parameter2}{the name of the second parameter}

\item{fileout}{the output file}

\item{title}{the plot title (default: "")}

\item{logspace}{true if the parameters should be plotted in logspace (default: TRUE)}

\item{scientific_notation}{true if the axis labels should be plotted in scientific notation (default: TRUE)}
}
\description{
Plot 2D profile likelihood estimations.
}
\examples{
dir.create(file.path("pe_plots"))
data(insulin_receptor_all_fits)
colnames(insulin_receptor_all_fits)[1] <- "ObjVal"
insulin_receptor_all_fits[,2:4] <- log10(insulin_receptor_all_fits[,2:4])
fileout <- file.path("pe_plots", "2d_ple_k1_k2.png")
plot_sampled_2d_ple(df=insulin_receptor_all_fits, 
                    parameter1="k1", 
                    parameter2="k2", 
                    fileout=fileout) 
}
