% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sazed.R
\name{Sa}
\alias{Sa}
\title{Compute the SA component of the SAZED ensemble}
\usage{
Sa(y, preprocess = T)
}
\arguments{
\item{y}{The input time series.}

\item{preprocess}{If true, y is detrended and z-normalized before
computation.}
}
\value{
The SA season length estimate of y.
}
\description{
\code{Sa} computes the autocorrelation of its argument, and then derives the
season length from its spectral density.
}
\examples{
season_length <- 26
y <- sin(1:400*2*pi/season_length)
Sa(y)
Sa(y, preprocess = FALSE)
}
