% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deliberate.r
\name{deliberate}
\alias{deliberate}
\title{Deliberation function}
\usage{
deliberate(g_votes, jury_n)
}
\arguments{
\item{g_votes}{Initial number of votes for guilty verdict (same as K value).}

\item{jury_n}{Size of the jury (i.e. 4, 6, 8, 12, or 16).}
}
\value{
Returns "G" (guilty verdict) or "NG" (not guilty verdict).
}
\description{
The deliberate function returns a jury verdict based on a simulation of deliberation
        as a modified tug-of-war between two verdict factions. Can be called directly, but is
        meant to be called many times to generate verdict probabilities based on g_votes and jury_n values.
}
\examples{
   library(sate)
   deliberate(g_votes=10, jury_n=12)

   deliberate(g_votes=4, jury_n=6)
}
