% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computePunstable.R
\name{computePunstable}
\alias{computePunstable}
\alias{computePunstable.snowprofileSet}
\alias{computePunstable.snowprofile}
\alias{computePunstable.snowprofileLayers}
\title{Compute probability of layer instability based on random forest model}
\usage{
computePunstable(x, ...)

\method{computePunstable}{snowprofileSet}(
  x,
  ski_pen = NA,
  recompute_crit_cut_length = TRUE,
  buffer = TRUE,
  ...
)

\method{computePunstable}{snowprofile}(x, ski_pen = NA, recompute_crit_cut_length = TRUE, ...)

\method{computePunstable}{snowprofileLayers}(x, ski_pen = NA, ...)
}
\arguments{
\item{x}{\link{snowprofile}, \link{snowprofileSet}, or \link{snowprofileLayers}}

\item{...}{passed on to subsequent methods}

\item{ski_pen}{skier penetration depth (m), one scalar for each profile in x}

\item{recompute_crit_cut_length}{This routine can very efficiently compute the critical crack length with \link{computeCritCutLength}.
SNOWPACK often provides NA values of the critical crack length even for layers that have a real solution to it. With this flag you can conveniently
recompute all critical crack lengths (\code{TRUE}). If set to \code{FALSE}, it will only be computed if not all profiles already contain it.
Note that shear strength must be available to compute the critical crack length!}

\item{buffer}{internal switch to ensure fast computation at low memory cost. Leave at \code{TRUE}!}
}
\value{
x is returned with \verb{$p_unstable} (and potentially \verb{$crit_cut_length}, \verb{$slab_rho}, and \code{slab_rhogs}) appended to each profile's layers object.
}
\description{
This function enables comfortable and fast R access to Stephanie Mayer's python implementation of her random forest model to estimate the probability of dry snow layer instability.
The routine can be run very efficiently on large \link{snowprofileSet}s. Layer properties required are sphericity, viscous deformation rate (10e-6 s-1), density (kg m-3), grain size (mm),
and the critical crack length (m) (which can be computed very efficiently automatically if shear strength (kPA) is available.) Additionally, skier penetration depth in (m) is required.
}
\section{Methods (by class)}{
\itemize{
\item \code{snowprofileSet}: for \link[sarp.snowprofile:snowprofileSet]{sarp.snowprofile::snowprofileSet}s

\item \code{snowprofile}: for \link{snowprofile}s

\item \code{snowprofileLayers}: for \link{snowprofileLayers}
}}

\examples{
## load a handful of example profiles from a PRO file
profiles <- snowprofilePro(system.file("extdata/snowprofile.pro",
                                       package = "sarp.snowprofile.pyface"),
                           remove_soil = TRUE, suppressWarnings = TRUE)
summary(profiles)
names(profiles[[1]]$layers)
## compute p_unstable alongside critical crack length, slab_rho, slab_rhogs:
if (have_dependencies()) {
profiles <- computePunstable(profiles)
names(profiles[[1]]$layers)
}


}
\references{
Mayer, S., Herwijnen, A. Van, Techel, F., & Schweizer, J. (accepted, 2022).
A random forest model to assess snow instability from simulated snow stratigraphy.
The Cryosphere Discussions. https://doi.org/10.5194/tc-2022-34
}
\author{
fherla and smayer
}
