% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterSPkdba.R
\name{clusterSPkdba}
\alias{clusterSPkdba}
\title{K-dimensional barycentric average clustering for snow profiles}
\usage{
clusterSPkdba(
  SPx,
  k,
  config = clusterSPconfig(type = "kdba"),
  centers = "centroids",
  distmat = NULL,
  keepSPx = TRUE
)
}
\arguments{
\item{SPx}{a \link[sarp.snowprofile:snowprofileSet]{sarp.snowprofile::snowprofileSet} to be clustered}

\item{k}{number of desired cluster numbers}

\item{config}{a list providing the necessary hyperparameters. Use \link{clusterSPconfig} function with \code{type = kdba} for convenience!}

\item{centers}{type of center to determine, either \code{centroids} (default) where an average profile is computed for each cluster
or \code{medoids} where the index of the medoid profile is identified}

\item{distmat}{a precomputed distance matrix of class dist (only used if \code{centers = medoids})}

\item{keepSPx}{append the snowprofileSet to the output?}
}
\value{
a list of class \code{clusterSP} containing:
\itemize{
\item \code{clustering}: vector of integers (from 1:k) indicating the cluster to which each point is allocated
\item \code{centroids}: snowprofileSet containing the centroid profile for each cluster (if calculated)
\item \code{clusters_history}: matrix with history of clustering over iterations
\item \code{iccentroids}: initial condition centroids
\item \code{niterations}: number of iterations
\item \code{converged}: did the algorithm converge?
\item \code{SPx}: a copy of the input snowprofileSet (if \code{keepSPx = TRUE})
}
}
\description{
K-dimensional barycentric average clustering for snow profiles
}
\examples{
this_example_runs_too_long <- TRUE
if (!this_example_runs_too_long) {  # exclude from cran checks
  cl_kdba <- clusterSPkdba(SPgroup2, k = 2)
  plot(cl_kdba)
}
}
\seealso{
\link{clusterSP}, \link{clusterSPcenters}
}
\author{
fherla shorton
}
