% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reScaleSampleSPx.R
\name{reScaleSampleSPx}
\alias{reScaleSampleSPx}
\title{Rescale and resample a snow profile list}
\usage{
reScaleSampleSPx(SPx, resamplingRate = 0.5, scHeight = median, ...)
}
\arguments{
\item{SPx}{list of \code{snowprofile} objects}

\item{resamplingRate}{resampling rate, units in centimeters}

\item{scHeight}{a function that calculates the resulting height from the profiles, default \code{median}}

\item{...}{arguments passed on to the function provided in \code{scHeight}}
}
\value{
A list with the first entry \verb{$set} storing the rescaled and resampled profile list, the second entry
\verb{$maxHS} stores the maximum snow height found among the profiles
}
\description{
Rescale and resample all snow profiles provided in a list to an identical snow height and resampling rate.
}
\examples{

## let's take the 'SPgroup' object as profile list
SPrr <- reScaleSampleSPx(SPgroup)
print(paste0("max height before rescaling: ", SPrr$maxHS, " cm"))
print(paste0("rescaled height: ", SPrr$set[[1]]$hs, " cm"))
plot(SPrr$set, SortMethod = 'unsorted')

}
\author{
fherla
}
