% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distMatSP.R
\name{distMatSP}
\alias{distMatSP}
\title{Calculate a multidimensional distance matrix between two profiles}
\usage{
distMatSP(
  query,
  ref,
  dims = c("hardness", "gtype"),
  weights = c(0.2, 0.8),
  gtype_distMat = sim2dist(grainSimilarity_align(FALSE)),
  prefLayerWeights = layerWeightingMat(FALSE),
  ddateNorm = 5,
  windowFunction = warpWindowSP,
  top.down.mirroring = FALSE,
  warn.if.na.in.distance.calc = FALSE,
  ...
)
}
\arguments{
\item{query}{The query snowprofile object}

\item{ref}{The ref snowprofile object}

\item{dims}{Character vector containing the layer properties to calculate the distance over. Currently implemented
are the properties \code{hardness}, \code{gtype}, \code{ddate}.}

\item{weights}{Numeric vector of the same length as \code{dims} specifying the averaging weights to each element of dims.}

\item{gtype_distMat}{A symmetric \strong{distance} scoring matrix provided as data.frame that stores information about
the distances between the encountered grain types of the provided profiles. Default is the corresponding distance
matrix of \link{grainSimilarity_align}, cf. \link{sim2dist}.}

\item{prefLayerWeights}{A matrix similar to \code{gtype_distMat}, but storing weights for preferential layer matching,
e.g. defaults to \link{layerWeightingMat}; the higher the values for a given grain type pair, the more the algorithm will try to
match those layers above others. To turn weighting scheme off, set \code{prefLayerWeights = NA}}

\item{ddateNorm}{Normalize the deposition date distance by \code{ddateNorm} number of days. Numeric, default 5.}

\item{windowFunction}{a window function analogous to \link{warpWindowSP} (Other compatible window functions can be
found in \link[dtw:dtwWindowingFunctions]{dtw::dtwWindowingFunctions}.)}

\item{top.down.mirroring}{Will the resulting distance matrix be used for top down alignments? i.e., do you want to mirror the
matrix about its anti-diagonal (top-left/bottom-right diagonal)?}

\item{warn.if.na.in.distance.calc}{most dependent functions in this package should be able to deal with NA values encountered in distance
calculations. Set this argument to \code{TRUE} if you want to be warned anyways.}

\item{...}{arguments to the window function, e.g. \code{window.size}, \code{window.size.abs}, \code{ddate.window.size}, ...}
}
\value{
A distance matrix of dimension (n x m), where n, m are the number of layers in the query and ref, respectively.
}
\description{
This routine calculates a distance matrix for two given profiles (\code{query} and \code{ref}). Analogously to other DTW
routines, the query is arranged along the matrix rows, the ref along the columns. Every cell of the matrix represents
the distance between the corresponding profile layers. The distance is calculated based on the specified layer properties
(e.g., \code{hardness}, \code{gtype}, \code{ddate}). The routine calls subroutines to calculate the distance for each property and
combines the normalized distances by weighted averaging.
}
\note{
For package developers: dot inputs to the function (i.e., \code{...}) also necessary to keep \link{dtwSP} highly flexible
and customizable. Dot inputs may contain arguments that remain unused in this function.
}
\examples{

## call function with two snow profiles of unequal lengths, without using a window function:
dMat_noWindow <- distMatSP(SPpairs$A_modeled, SPpairs$A_manual, windowFunction = NA)
graphics::image(dMat_noWindow, main = "Default distance matrix without a warping window")


## compute distance based on grain type alone,
## and additionally disable preferential layer matching:
dMat <- distMatSP(SPpairs$A_modeled, SPpairs$A_manual, windowFunction = NA,
                  dims = "gtype", weights = 1, prefLayerWeights = NA)
graphics::image(dMat,
                main = "Only based on grain type, and without preferential layer matching")

## enable preferential layer matching:
dMat <- distMatSP(SPpairs$A_modeled, SPpairs$A_manual, windowFunction = NA)
graphics::image(dMat,
                main = "... with preferential layer matching")


## using a warping window:
dMat <- distMatSP(SPpairs$A_modeled, SPpairs$A_manual, window.size.abs = 50)
graphics::image(dMat, main = "... and superimposing an absolute warping window of 50 cm")

}
\seealso{
\link{resampleSPpairs}
}
\author{
fherla
}
