% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R
\name{fillet}
\alias{fillet}
\title{Chop data precisely (for programmers)}
\usage{
fillet(x, breaks, labels)
}
\arguments{
\item{x}{A numeric vector.}

\item{breaks}{See below.}

\item{labels}{See below.}
}
\value{
A \link{factor} of the same length as \code{x}, representing the intervals containing
the value of \code{x}.
}
\description{
Chop data precisely (for programmers)
}
\details{
\code{fillet()} calls \code{\link[=chop]{chop()}} with \code{extend = FALSE} and \code{drop = FALSE}. This
ensures that you get only the \code{breaks} and \code{labels} you ask for. When
programming, consider using \code{fillet()} instead of \code{chop()}.
}
\examples{
fillet(1:10, c(2, 5, 8))
}
\seealso{
Other chopping functions: 
\code{\link{brk_mean_sd}()},
\code{\link{brk_n}()},
\code{\link{brk_quantiles}()},
\code{\link{brk_width}()},
\code{\link{chop}()}
}
\concept{chopping functions}
