% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/salad.r
\name{salad}
\alias{salad}
\title{Salad options}
\usage{
salad(...)
}
\arguments{
\item{...}{options to be defined, using 'name = value', or name(s) of 
option(s) to get.}
}
\value{
A list with the defined options, or a single element when \code{salad(name)}
is used.
}
\description{
Set or get options values for package 'salad'
}
\details{
Currently, only one option can be defined, \code{drop.derivatives}, 
which modifies the bevahiour of S3 methods \code{as.vector} and \code{as.matrix}
and corresponding S4 methods. 
The default value is set to 'TRUE', which means that
\code{as.vector} and \code{as.matrix} will return a 'base' objects, without
derivatives. Setting \code{drop.derivatives = FALSE} will make these functions
return an object of class dual. This might be useful to re-use exiting code, 
but may cause some functions to break, and should be use with care.

Use \code{salad()} to get the current value of all options, or
\code{salad(name)} to get the current value of a given option.
}
\examples{
salad("drop.derivatives")
x <- dual(matrix(c(1,2,3,4), 2, 2))
salad(drop.derivatives = FALSE)
as.vector(x)
salad(drop.derivatives = TRUE)
as.vector(x)
}
