% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaemixData.R
\name{transformCatCov}
\alias{transformCatCov}
\title{Transform covariates}
\usage{
transformCatCov(object, covariate, group, reference, verbose = FALSE)
}
\arguments{
\item{object}{saemixData object}

\item{covariate}{name of the covariate}

\item{group}{a vector giving the categories to which the initial values of the covariates should be mapped. If the resulting covariate is binary, it will be stored as 0/1. If it has more than 2 categories, dummy covariates will be created for the analysis.}

\item{reference}{the reference group}

\item{verbose}{a boolean, prints messages during the execution of the function if TRUE. Defaults to FALSE.}
}
\value{
an object of class \code{"\linkS4class{SaemixData}"}
}
\description{
Regroup categorical covariates
}
\examples{
data(cow.saemix)
saemix.data<-saemixData(name.data=cow.saemix,header=TRUE,name.group=c("cow"),
                   name.predictors=c("time"),name.response=c("weight"),
                   name.covariates=c("birthyear","twin","birthrank"),
                   units=list(x="days",y="kg",covariates=c("yr","-","-")))
unique(saemix.data@data$birthrank) # 5 categories, 3 4 5 6 7
# create 2 dummy variables regrouping 4 and 5, and 6 and 7
cowt <- transformCatCov(saemix.data, covariate=birthrank, group=c(1,2,2,3,3), verbose=TRUE) 
head(saemix.data@data) # the original covariate is birthrank
head(cowt@data) 
# the new covariates are birthrank.G2 (regrouping 4 and 5) and birthrank.G3 (6 and 7)

}
\keyword{data}
