% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forward.R
\name{forward.procedure}
\alias{forward.procedure}
\title{Backward procedure for joint selection of covariates and random effects}
\usage{
forward.procedure(saemixObject, trace = TRUE)
}
\arguments{
\item{saemixObject}{An object returned by the \code{\link{saemix}} function}

\item{trace}{If TRUE, a table summarizing the steps of the algorithm is printed. Default "TRUE"}
}
\value{
An object of the SaemixObject class storing the covariate model and the covariance structure of
random effects of the final model.
}
\description{
Joint selection of covariates and random effects in a nonlinear mixed effects model by a forward-type
algorithm based on two different versions of BIC for covariate selection and random effects selection
respectively. Selection is made among the covariates as such specified in the SaemixData object.
Only uncorrelated random effects structures are considered.
}
\references{
M Delattre, M Lavielle, MA Poursat (2014) A note on BIC in mixed effects models.
Electronic Journal of Statistics 8(1) p. 456-475
M Delattre, MA Poursat (2017) BIC strategies for model choice in a population approach.
(arXiv:1612.02405)
}
\author{
Maud Delattre
}
\keyword{covariate}
\keyword{forward}
\keyword{selection}
